import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import MonitoraggioSpecieForm from "../../../../core/Forms/MonitoraggioSpecieForm/MonitoraggioSpecieForm";
import {authUserQuery, monitoraggioSpecieQuery} from "../../../../api/queries";
import {findById} from "../../../../utils";
import Loading from "../../../../core/Loading/Loading";

class Edit extends Component {

    constructor(props) {
        super(props);

        this.state = {
            submitting: false,
            error: false,
        };
    }

    render() {
        const {
            data,
            utenteSessione
        } = this.props;

        if(data.loading) {
            return (<Loading/>);
        }

        return (<div className="container" style={{marginBottom: '20px'}}>
            <h1>Salva Monitoraggio Specie</h1>
            <MonitoraggioSpecieForm
                data={data}
                utenteSessione={utenteSessione}
                submitMutation={gql`
                    mutation($monitoraggio: MonitoraggioSpecieInput) {
                        updateMonitoraggioSpecie(monitoraggioSpecie: $monitoraggio) {
                            id
                        }
                    }`} />
        </div>);
    }
}

export default compose(
    graphql(monitoraggioSpecieQuery, {
        options:({match}) => ({variables: {id: match.params.id}}),
    }),
    graphql(authUserQuery, {name: 'utenteSessione'})
)(Edit);

Edit.defaultProps = {};

Edit.propTypes = {};